local BLMasses = {
	CRL_BASE	= 1186.6,
	MAU12		= 31.75,
	HSAB		= 1088.6,
	SUU67A		= 2016.7,
}

local HSAB_ConnOrders = {
	[2] = { 8, 2 },
	[4] = {
		L = {5},
		R = {5},
	},
	[5] = { 7, 1, 9, 3, 5 },
	[6] = {
		L = { 2, 8, 3, 1, 9, 7 },
		R = { 2, 8, 1, 3, 7, 9 },
	},
	[8] = {
		L = { 2, 8, 3, 1, 6, 4, 9, 7 },
		R = { 2, 8, 1, 3, 4, 6, 7, 9 },
	},
	[9] = { 7, 1, 9, 3, 4, 6, 8, 5, 2 },
}

local Bay_ConnOrders = {
	[3] = { 32, 33, 34 },
	[6] = { 29, 31, 32, 34, 35, 37 },
	[27] = {
		29, 20, 38, 30, 21, 39, 31, 22, 40,
		32, 23, 41, 33, 24, 42, 34, 25, 43,
		35, 26, 44, 36, 27, 45, 37, 28, 46,
	}
}

local function HSAB_Elements(shapeName, count, isLeft)
	local result = {{ ShapeName = "b-52_HSAB", IsAdapter = true }}
	local connOrder

	if count ~= 2 and math.fmod(count, 2) == 0 then
		if isLeft ~= false then
			connOrder = HSAB_ConnOrders[count].L
		else
			connOrder = HSAB_ConnOrders[count].R
		end
	else
		connOrder = HSAB_ConnOrders[count]
	end

	for i = #connOrder, 1, -1 do
		result[#result + 1] = { ShapeName = shapeName, connector_name = ("Pylon%d"):format(connOrder[i]) }
	end

	return result
end

local function Bay_Elements(shapeName, count)
	local result = {}

	for i = #Bay_ConnOrders[count], 1, -1 do
		result[#result + 1] = { ShapeName = shapeName, connector_name = ("Pylon%d"):format(Bay_ConnOrders[count][i]) }
	end

	return result
end

local function CSRL_Elements(shapeName)
	local result = {{ ShapeName = "b-52_CRL_mod1", IsAdapter = true }}

	for i = 1, 8 do
		result[#result + 1] = { ShapeName = shapeName, connector_name = ("Pylon%d"):format(i) }
	end

	return result
end

--#region HSAB
--#region CBU

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{4CD2BB0F-5493-44EF-A927-9760350F7BA1}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, 79 },
	wsTypeOfWeapon	= "weapons.bombs.ROCKEYE",
	displayName		= "HSAB - 9 x " .. _("Mk-20 Rockeye - 490lbs CBU, 247 x HEAT Bomblets"),
	Picture			= "Mk20.png",
	Count			= 9,
	Cx_pil			= 9 * 0.000265 + 0.005,
	Weight			= 9 * 222 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("Rockeye", 9),
	settings		= Get_Fuze_GUISettings_Preset("MDRN_CC_A_Mk20")
})

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{HSAB_CBU87}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.CBU_87",
	displayName		= "HSAB - 9 x " .. _("CBU-87 - 202 x CEM Cluster Bomb"),
	Picture			= "CBU.png",
	Count			= 9,
	Cx_pil			= 9 * 0.000265 + 0.005,
	Weight			= 9 * 420 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("CBU-97", 9),
	settings		= Get_Combined_GUISettings_Preset("CBU_SUU65Plus")
})

--#endregion CBU
--#region GPLD

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{585D626E-7F42-4073-AB70-41E728C333E2}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, 74 },
	wsTypeOfWeapon	= "weapons.bombs.Mk_82",
	displayName		= "HSAB - 9 x " .. _("Mk-82 - 500lb GP Bomb LD"),
	Picture			= "Mk82.png",
	Count			= 9,
	Cx_pil			= 9 * 0.00016 + 0.005,
	Weight			= 9 * 228 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("Mk-82", 9),
	settings		= Get_Combined_GUISettings_Preset("MDRN_B_A_GPLD")
})

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{HSAB_M117}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.M_117",
	displayName		= "HSAB - 9 x " .. _("M117 - 750lb GP Bomb LD"),
	Picture			= "KMGU2.png",
	Count			= 9,
	Cx_pil			= 9 * 0.001 + 0.005,
	Weight			= 9 * 408 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("M117", 9),
})

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{696CFFC4-0BDE-42A8-BE4B-0BE3D9DD723C}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, 78 },
	wsTypeOfWeapon	= "weapons.bombs.Mk_84",
	displayName		= "HSAB - 6 x " .. _("Mk-84 - 2000lb GP Bomb LD"),
	Picture			= "Mk84.png",
	Count			= 6,
	Cx_pil			= 6 * 0.000357 + 0.005,
	Weight			= 6 * 908 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("Mk-84", 6),
	settings		= Get_Combined_GUISettings_Preset("MDRN_B_A_GPLD")
})

--#endregion GPLD
--#region GPHD

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{HSAB_Mk82AIR}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.MK_82AIR",
	displayName		= "HSAB - 9 x " .. _("Mk-82 AIR Ballute - 500lb GP Bomb HD"),
	Picture			= "mk82AIR.png",
	Count			= 9,
	Cx_pil			= 9 * 0.000186 + 0.005,
	Weight			= 9 * 242 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("Mk-82AIR", 9),
	settings		= Get_Combined_GUISettings_Preset("MDRN_B_A_GPHD")
})

--#endregion GPHD
--#region JDAM

local GBU31V1_L = {
	category		= CAT_BOMBS,
	CLSID			= "{HSAB_6x_GBU31V1_L}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.GBU_31",
	displayName		= "HSAB - 6 x " .. _("GBU-31(V)1/B - JDAM, 2000lb GPS Guided Bomb"),
	Picture			= "GBU31.png",
	Count			= 6,
	Cx_pil			= 6 * 0.00264 + 0.005,
	Weight			= 6 * 925 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("GBU-31", 6, true),
	settings		= Get_Fuze_GUISettings_Preset("MDRN_B_A_PGM_TWINWELL"),
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
}
local GBU31V1_R = {}

copy_recursive(GBU31V1_R, GBU31V1_L)
GBU31V1_R.CLSID		= "{HSAB_6x_GBU31V1_R}"
GBU31V1_R.Elements	= HSAB_Elements("GBU-31", 6, false)

declare_loadout(GBU31V1_L)
declare_loadout(GBU31V1_R)

local GBU31V3_L = {
	category		= CAT_BOMBS,
	CLSID			= "{HSAB_6x_GBU31V3_L}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.GBU_31_V_3B",
	displayName		= "HSAB - 6 x " .. _("GBU-31(V)3/B - JDAM, 2000lb GPS Guided Penetrator Bomb"),
	Picture			= "GBU-31V3B.png",
	Count			= 6,
	Cx_pil			= 6 * 0.0017 + 0.005,
	Weight			= 6 * 961 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("GBU31_V_3B_BLU109", 6, true),
	settings		= Get_Fuze_GUISettings_Preset("MDRN_B_A_PGM_HTP"),
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
}
local GBU31V3_R = {}

copy_recursive(GBU31V3_R, GBU31V3_L)
GBU31V3_R.CLSID		= "{HSAB_6x_GBU31V3_R}"
GBU31V3_R.Elements	= HSAB_Elements("GBU31_V_3B_BLU109", 6, false)

declare_loadout(GBU31V3_L)
declare_loadout(GBU31V3_R)

local GBU38_6_L = {
	category		= CAT_BOMBS,
	CLSID			= "{HSAB_6x_GBU38V1_L}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.GBU_38",
	displayName		= "HSAB - 6 x " .. _("GBU-38(V)1/B - JDAM, 500lb GPS Guided Bomb"),
	Picture			= "GBU38.png",
	Count			= 6,
	Cx_pil			= 6 * 0.00074 + 0.005,
	Weight			= 6 * 253.1 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("GBU-38", 6, true),
	settings		= Get_Fuze_GUISettings_Preset("MDRN_B_A_PGM_TWINWELL"),
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
}
local GBU38_6_R = {}

copy_recursive(GBU38_6_R, GBU38_6_L)
GBU38_6_R.CLSID		= "{HSAB_6x_GBU38V1_R}"
GBU38_6_R.Elements	= HSAB_Elements("GBU-38", 6, false)

declare_loadout(GBU38_6_L)
declare_loadout(GBU38_6_R)

--#region IWBU

local GBU38_8_L = {
	category		= CAT_BOMBS,
	CLSID			= "{HSAB_8x_GBU38V1_L}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.GBU_38",
	displayName		= "HSAB - 8 x " .. _("GBU-38(V)1/B - JDAM, 500lb GPS Guided Bomb"),
	Picture			= "GBU38.png",
	Count			= 8,
	Cx_pil			= 8 * 0.00074 + 0.005,
	Weight			= 8 * 253.1 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("GBU-38", 8, true),
	settings		= Get_Fuze_GUISettings_Preset("MDRN_B_A_PGM_TWINWELL"),
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
}
local GBU38_8_R = {}

copy_recursive(GBU38_8_R, GBU38_8_L)
GBU38_8_R.CLSID		= "{HSAB_8x_GBU38V1_R}"
GBU38_8_R.Elements	= HSAB_Elements("GBU-38", 8, false)

declare_loadout(GBU38_8_L)
declare_loadout(GBU38_8_R)

local GBU54_8_L = {
	category		= CAT_BOMBS,
	CLSID			= "{HSAB_8x_GBU54V1_L}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.GBU_54_V_1B",
	displayName		= "HSAB - 8 x " .. _("GBU-54(V)1/B - LJDAM, 500lb Laser & GPS Guided Bomb LD"),
	Picture			= "GBU54.png",
	Count			= 8,
	Cx_pil			= 8 * 0.00074 + 0.005,
	Weight			= 8 * 253.1 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("GBU-54", 8, true),
	settings		= Get_Combined_GUISettings_Preset("LJDAM"),
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
}
local GBU54_8_R = {}

copy_recursive(GBU54_8_R, GBU54_8_L)
GBU54_8_R.CLSID		= "{HSAB_8x_GBU54V1_R}"
GBU54_8_R.Elements	= HSAB_Elements("GBU-54", 8, false)

declare_loadout(GBU54_8_L)
declare_loadout(GBU54_8_R)

--#endregion IWBU
--#endregion JDAM
--#region JSOW

local AGM154_L = {
	category		= CAT_MISSILES,
	CLSID			= "{HSAB_6x_AGM154A_L}",
	attribute		= { wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.missiles.AGM_154A",
	displayName		= "HSAB - 6 x " .. _("AGM-154A - JSOW CEB (CBU-type)"),
	Picture			= "AGM154.png",
	Count			= 6,
	Cx_pil			= 6 * 8 / 4096 + 0.005,
	Weight			= 6 * 485 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("AGM-154", 6, true),
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
}
local AGM154_R = {}

copy_recursive(AGM154_R, AGM154_L)
AGM154_R.CLSID		= "{HSAB_6x_AGM154A_R}"
AGM154_R.Elements	= HSAB_Elements("AGM-154", 6, false)

declare_loadout(AGM154_L)
declare_loadout(AGM154_R)

--#endregion JSOW
--#region WCMD

local CBU103_L = {
	category		= CAT_BOMBS,
	CLSID			= "{HSAB_8x_CBU103_L}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.CBU_103",
	displayName		= "HSAB - 8 x " .. _("CBU-103 - 202 x CEM, CBU with WCMD"),
	Picture			= "CBU.png",
	Count			= 8,
	Cx_pil			= 8 * 0.000265 + 0.005,
	Weight			= 8 * 430 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("CBU-97", 8, true),
	settings		= Get_Combined_GUISettings_Preset("CBU_SUU65Plus"),
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
}
local CBU103_R = {}

copy_recursive(CBU103_R, CBU103_L)
CBU103_R.CLSID		= "{HSAB_8x_CBU103_R}"
CBU103_R.Elements	= HSAB_Elements("CBU-97", 8, false)

declare_loadout(CBU103_L)
declare_loadout(CBU103_R)

local CBU105_L = {
	category		= CAT_BOMBS,
	CLSID			= "{HSAB_8x_CBU105_L}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.CBU_105",
	displayName		= "HSAB - 8 x " .. _("CBU-105 - 10 x SFW, CBU with WCMD"),
	Picture			= "CBU.png",
	Count			= 8,
	Cx_pil			= 8 * 0.000265 + 0.005,
	Weight			= 8 * 417 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("CBU-97", 8, true),
	settings		= Get_Fuze_GUISettings_Preset("MDRN_CC_A_SUU65Plus_SFW"),
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
}
local CBU105_R = {}

copy_recursive(CBU105_R, CBU105_L)
CBU105_R.CLSID		= "{HSAB_8x_CBU105_R}"
CBU105_R.Elements	= HSAB_Elements("CBU-97", 8, false)

declare_loadout(CBU105_L)
declare_loadout(CBU105_R)

--#endregion WCMD
--#region AGM-84

local AGM84D_L = {
	category		= CAT_MISSILES,
	CLSID			= "{HSAB_4x_AGM84D_L}",
	attribute		= { wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.missiles.AGM_84D",
	displayName		= "NASA " .. _("X-15"),
	Picture			= "AGM84D.png",
	Count			= 1,
	Cx_pil			= 4 * 8 / 4096 + 0.005,
	Weight			= 4 * 540 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
	Elements = HSAB_Elements("AGM-84D", 4, true)
}
local AGM84D_R = {}

copy_recursive(AGM84D_R, AGM84D_L)
AGM84D_R.CLSID		= "{HSAB_4x_AGM84D_R}"
AGM84D_R.Elements	= HSAB_Elements("AGM-84D", 4, false)

declare_loadout(AGM84D_L)
declare_loadout(AGM84D_R)

--#endregion AGM-84
--#region LGB

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{HSAB_5x_GBU10}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.GBU_10",
	displayName		= "HSAB - 5 x " .. _("GBU-10 - 2000lb Laser Guided Bomb"),
	Picture			= "GBU10.png",
	Count			= 5,
	Cx_pil			= 5 * 0.000508 + 0.005,
	Weight			= 5 * 959 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("GBU-10", 5),
	settings		= Get_Combined_GUISettings_Preset("Paveway_II"),
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
})

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{HSAB_5x_GBU12}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.GBU_12",
	displayName		= "HSAB - 5 x " .. _("GBU-12 - 500lb Laser Guided Bomb"),
	Picture			= "GBU12.png",
	Count			= 5,
	Cx_pil			= 5 * 0.000365 + 0.005,
	Weight			= 5 * 277 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("GBU-12", 5),
	settings		= Get_Combined_GUISettings_Preset("Paveway_II"),
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
})

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{HSAB_2x_GBU28}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.GBU_28",
	displayName		= "HSAB - 2 x " .. _("GBU-28 - 5000lb Laser Guided Penetrator Bomb"),
	Picture			= "GBU27.png",
	Count			= 2,
	Cx_pil			= 2 * 0.0014 + 0.005,
	Weight			= 2 * 2130 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	Elements		= HSAB_Elements("GBU-28", 2),
	settings		= Get_Combined_GUISettings_Preset("Paveway_III_HTP"),
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
})

--#endregion LGB
--#endregion HSAB

--#region SUU67

local ALCM_MER_ELEMENTS = function ()
	return
	{
		{ ShapeName = "b-52_suu67", IsAdapter = true },
		-- Adjusted per T.O. 1B-52H-34-2-9
		{ ShapeName = "AGM-86", connector_name = "Pylon6" },
		{ ShapeName = "AGM-86", connector_name = "Pylon4" },
		{ ShapeName = "AGM-86", connector_name = "Pylon5" },
		{ ShapeName = "AGM-86", connector_name = "Pylon2" },
		{ ShapeName = "AGM-86", connector_name = "Pylon1" },
		{ ShapeName = "AGM-86", connector_name = "Pylon3" },
	}
end

declare_loadout({CLSID = "{45447F82-01B5-4029-A572-9AAD28AF0275}",category = CAT_MISSILES,
	Picture				= "AGM86.png",
	wsTypeOfWeapon		= {4,	4,	8,	64},
	displayName			= _("6 x AGM-86D on MER"),
	attribute			= {4,	4,	32,	67},
	Cx_pil				= 6 * 8 / 4096 + 0.000681,
	Count				= 6,
	Weight				= 6 * 1450 + BLMasses.SUU67A,
	Weight_Empty		= BLMasses.SUU67A,
	ejectVelocity		= 1,
	ejectPitchRate		= -10,
	kind_of_shipping	= 0, -- //SUBMUNITION_ONLY
	Elements 			= ALCM_MER_ELEMENTS()
})

--#endregion SUU67

--#region Bay
--#region CBU

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{B52H_BAY_6x_CBU87}",
	attribute		= "weapons.bombs.CBU_87",
	displayName		= "6 x " .. _("CBU-87 - 202 x CEM Cluster Bomb"),
	Picture			= "CBU.png",
	Count			= 6,
	Cx_pil			= 0,
	Cx_item			= 0,
	Weight			= 6 * 420,
	ejectVelocity	= 2,
	Elements		= Bay_Elements("CBU-97", 6),
	settings		= Get_Combined_GUISettings_Preset("CBU_SUU65Plus"),
	DistributeOverCarrierDirectly = true
})

--#endregion CBU
--#region GPLD

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{6C47D097-83FF-4FB2-9496-EAB36DDF0B05}",
	attribute		= "weapons.bombs.Mk_82",
	displayName		= "27 x " .. _("Mk-82 - 500lb GP Bomb LD"),
	Picture			= "mk82.png",
	Count			= 27,
	Cx_pil			= 0,
	Cx_item			= 0,
	Weight			= 27 * 228,
	ejectVelocity	= 2,
	Elements		= Bay_Elements("Mk-82", 27),
	settings		= Get_Fuze_GUISettings_Preset("MDRN_B_A_GPLD"),
	DistributeOverCarrierDirectly = true,
})

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{B52H_BAY_M117}",
	attribute		= "weapons.bombs.M_117",
	displayName		= "27 x " .. _("M117 - 750lb GP Bomb LD"),
	Picture			= "KMGU2.png",
	Count			= 27,
	Cx_pil			= 0,
	Cx_item			= 0,
	Weight			= 27 * 408,
	ejectVelocity	= 2,
	Elements		= Bay_Elements("M117", 27),
	DistributeOverCarrierDirectly = true,
})

--#endregion GPLD
--#region GPHD

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{B52H_BAY_Mk82AIR}",
	attribute		= "weapons.bombs.MK_82AIR",
	displayName		= "27 x " .. _("Mk-82 AIR Ballute - 500lb GP Bomb HD"),
	Picture			= "mk82AIR.png",
	Count			= 27,
	Cx_pil			= 0,
	Cx_item			= 0,
	Weight			= 27 * 242,
	ejectVelocity	= 2,
	Elements		= Bay_Elements("Mk-82AIR", 27),
	settings		= Get_Fuze_GUISettings_Preset("MDRN_B_A_GPHD"),
	DistributeOverCarrierDirectly = true,
})

--#endregion GPHD
--#region LGB

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{B52H_BAY_3x_GBU12}",
	attribute		= "weapons.bombs.GBU_12",
	displayName		= "3 x " .. _("GBU-12 - 500lb Laser Guided Bomb"),
	Picture			= "GBU12.png",
	Count			= 3,
	Cx_pil			= 0,
	Cx_item			= 0,
	Weight			= 3 * 277,
	ejectVelocity	= 2,
	Elements		= Bay_Elements("GBU-12", 3),
	settings		= Get_Combined_GUISettings_Preset("Paveway_II"),
	DistributeOverCarrierDirectly = true,
})

--#endregion LGB
--#region CSRL

local function ALCM_ROTARY(tbl)
	tbl.category 		 = CAT_MISSILES
	tbl.Count 			 = 8
	tbl.kind_of_shipping = 0
	tbl.Picture			 =	"AGM86.png"
	tbl.attribute	=	{4,	4,32,WSTYPE_PLACEHOLDER}
	tbl.Elements	=	{
		{ShapeName = "b-52_CSRL_ALCM", IsAdapter = true},
		-----------------------------------------------------
		{ShapeName = "agm-86", connector_name = "Pylon1"},
		{ShapeName = "agm-86", connector_name = "Pylon2"},
		{ShapeName = "agm-86", connector_name = "Pylon3"},
		{ShapeName = "agm-86", connector_name = "Pylon4"},
		{ShapeName = "agm-86", connector_name = "Pylon5"},
		{ShapeName = "agm-86", connector_name = "Pylon6"},
		{ShapeName = "agm-86", connector_name = "Pylon7"},
		{ShapeName = "agm-86", connector_name = "Pylon8"},
	}
	return tbl
end

--HATCH MISSILES LOADOUT , TODO  make rotary
declare_loadout(ALCM_ROTARY({CLSID = "{8_x_AGM_86C}",
	wsTypeOfWeapon	= "weapons.missiles.AGM_86C",
	displayName		= _("8 x AGM-86C"),
	Weight			= 8 * (BLMasses.MAU12 + 1950) + BLMasses.CRL_BASE,
	Weight_Empty	= 8 * BLMasses.MAU12 + BLMasses.CRL_BASE,
	Cx_pil			= 0,
	Cx_item			= 0,
	ejectVelocity	= 1,
	ejectPitchRate	= -10,
}))

declare_loadout(ALCM_ROTARY({CLSID = "{8DCAF3A3-7FCF-41B8-BB88-58DEDA878EDE}",
	wsTypeOfWeapon	= {4,	4,	8,	64},
	displayName		= _("8 x AGM-86D"),
	Weight			= 8 * (BLMasses.MAU12 + 1450) + BLMasses.CRL_BASE,
	Weight_Empty	= 8 * BLMasses.MAU12 + BLMasses.CRL_BASE,
	Cx_pil			= 0,
	Cx_item			= 0,
	ejectVelocity	= 1,
	ejectPitchRate	= -10,
}))

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{CSRL_GBU12}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.GBU_12",
	displayName		= "CSRL - 8 x " .. _("GBU-12 - 500lb Laser Guided Bomb"),
	Picture			= "GBU12.png",
	Count			= 8,
	Cx_pil			= 0,
	Cx_item			= 0,
	Weight			= 8 * (BLMasses.MAU12 + 277) + BLMasses.CRL_BASE,
	Weight_Empty	= 8 * BLMasses.MAU12 + BLMasses.CRL_BASE,
	Elements		= CSRL_Elements("GBU-12"),
	settings		= Get_Combined_GUISettings_Preset("Paveway_II"),
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
})

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{CSRL_GBU31V1}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.GBU_31",
	displayName		= "CSRL - 8 x " .. _("GBU-31(V)1/B - JDAM, 2000lb GPS Guided Bomb"),
	Picture			= "GBU31.png",
	Count			= 8,
	Cx_pil			= 0,
	Cx_item			= 0,
	Weight			= 8 * (BLMasses.MAU12 + 925) + BLMasses.CRL_BASE,
	Weight_Empty	= 8 * BLMasses.MAU12 + BLMasses.CRL_BASE,
	Elements		= CSRL_Elements("GBU-31"),
	settings		= Get_Fuze_GUISettings_Preset("MDRN_B_A_PGM_TWINWELL"),
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
})

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{CSRL_GBU31V3}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.GBU_31_V_3B",
	displayName		= "CSRL - 8 x " .. _("GBU-31(V)3/B - JDAM, 2000lb GPS Guided Penetrator Bomb"),
	Picture			= "GBU-31V3B.png",
	Count			= 8,
	Cx_pil			= 0,
	Cx_item			= 0,
	Weight			= 8 * (BLMasses.MAU12 + 961) + BLMasses.CRL_BASE,
	Weight_Empty	= 8 * BLMasses.MAU12 + BLMasses.CRL_BASE,
	Elements		= CSRL_Elements("GBU31_V_3B_BLU109"),
	settings		= Get_Fuze_GUISettings_Preset("MDRN_B_A_PGM_HTP"),
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
})

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{CSRL_GBU38V1}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.GBU_38",
	displayName		= "CSRL - 8 x " .. _("GBU-38(V)1/B - JDAM, 500lb GPS Guided Bomb"),
	Picture			= "GBU38.png",
	Count			= 8,
	Cx_pil			= 0,
	Cx_item			= 0,
	Weight			= 8 * (BLMasses.MAU12 + 253.1) + BLMasses.CRL_BASE,
	Weight_Empty	= 8 * BLMasses.MAU12 + BLMasses.CRL_BASE,
	Elements		= CSRL_Elements("GBU-38"),
	settings		= Get_Fuze_GUISettings_Preset("MDRN_B_A_PGM_TWINWELL"),
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
})

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{CSRL_GBU54V1}",
	attribute		= { wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER },
	wsTypeOfWeapon	= "weapons.bombs.GBU_54_V_1B",
	displayName		= "CSRL - 8 x " .. _("GBU-54(V)1/B - LJDAM, 500lb Laser & GPS Guided Bomb LD"),
	Picture			= "GBU54.png",
	Count			= 8,
	Cx_pil			= 0,
	Cx_item			= 0,
	Weight			= 8 * (BLMasses.MAU12 + 253.1) + BLMasses.CRL_BASE,
	Weight_Empty	= 8 * BLMasses.MAU12 + BLMasses.CRL_BASE,
	Elements		= CSRL_Elements("GBU-54"),
	settings		= Get_Combined_GUISettings_Preset("LJDAM"),
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
})

--#endregion CSRL
--#endregion Bay

--#region Legacy

local function HSAB(element,tb)
	tb.Elements = 
	{
		{ShapeName = "b-52_HSAB",IsAdapter = true}, 
		------------------------------------------------------------------------------------
		{ShapeName = element, connector_name = "Pylon1"},
		{ShapeName = element, connector_name = "Pylon3"},	
		{ShapeName = element, connector_name = "Pylon4"}, 
		{ShapeName = element, connector_name = "Pylon6"},  
		{ShapeName = element, connector_name = "Pylon7"}, 
		{ShapeName = element, connector_name = "Pylon9"}, 
		{ShapeName = element, connector_name = "Pylon2"}, 
		{ShapeName = element, connector_name = "Pylon5"}, 
		{ShapeName = element, connector_name = "Pylon8"}, 
		
	} 
	return tb
end

local function HSAB6(element,tb)
	tb.Elements = 
	{
		{ShapeName = "b-52_HSAB",IsAdapter = true}, 
		------------------------------------------------------------------------------------
		{ShapeName = element, connector_name = "Pylon1"},
		{ShapeName = element, connector_name = "Pylon3"},	
		{ShapeName = element, connector_name = "Pylon7"}, 
		{ShapeName = element, connector_name = "Pylon9"}, 
		{ShapeName = element, connector_name = "Pylon2"}, 
		{ShapeName = element, connector_name = "Pylon8"}, 
	} 
	return tb
end

declare_loadout({CLSID = "{46ACDCF8-5451-4E26-BDDB-E78D5830E93C}",category = CAT_MISSILES,
	Picture		=	"agm84a.png",
	displayName	=	_("8 x AGM-84A Harpoon ASM"),
	Weight		=	5292,
	Count		=	8,
	attribute	=	{4,	4,	8,	62},
	Elements	=	{{ShapeName = "AGM-84"}},
})

declare_loadout(HSAB6("AGM-84",{CLSID = "{HSAB-6xAGM-84}",category = CAT_MISSILES,
	Picture			= "agm84a.png",
	displayName		= _("HSAB with 6 x AGM-84"),
	attribute		= {4,	4,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= {4,	4,	8,	62},
	Cx_pil			= 0.005 + 6 * 6 / 4096,
	Cx_item			= 6 / 4096,
	Count			= 6,
	Weight			= 6 * 661 + BLMasses.HSAB,
	Weight_Empty	= BLMasses.HSAB,
	ejectVelocity	= 2,
	ejectPitchRate	= -10,
}))

--#endregion Legacy

local function WING_LOADOUT(left)
	local result = {
		-- CBU
		{ CLSID = "{4CD2BB0F-5493-44EF-A927-9760350F7BA1}",	arg_value = 0.1,	DrawArgs = {{18, 0.1}} }, -- HSAB - 9 x Mk-20
		{ CLSID = "{HSAB_CBU87}",							arg_value = 0.1,	DrawArgs = {{18, 0.1}} },
		-- GPLD
		{ CLSID = "{585D626E-7F42-4073-AB70-41E728C333E2}",	arg_value = 0.1,	DrawArgs = {{18, 0.1}} }, -- HSAB - 9 x Mk-82
		{ CLSID = "{HSAB_M117}",							arg_value = 0.1,	DrawArgs = {{18, 0.1}} },
		{ CLSID = "{696CFFC4-0BDE-42A8-BE4B-0BE3D9DD723C}",	arg_value = 0.1,	DrawArgs = {{18, 0.2}} }, -- HSAB - 6 x Mk-84
		-- GPHD
		{ CLSID = "{HSAB_Mk82AIR}",							arg_value = 0.1,	DrawArgs = {{18, 0.1}} },
		-- JDAM
		{ CLSID = "{HSAB_6x_GBU31V1_R}",					arg_value = 0.1,	DrawArgs = {{18, 0.2}} },
		{ CLSID = "{HSAB_6x_GBU31V3_R}",					arg_value = 0.1,	DrawArgs = {{18, 0.2}} },
		{ CLSID = "{HSAB_6x_GBU38V1_R}",					arg_value = 0.1,	DrawArgs = {{18, 0.1}} },
		{ CLSID = "{HSAB_8x_GBU38V1_R}",					arg_value = 0.1,	DrawArgs = {{18, 0.1}} },
		{ CLSID = "{HSAB_8x_GBU54V1_R}",					arg_value = 0.1,	DrawArgs = {{18, 0.1}} },
		-- JSOW
		{ CLSID = "{HSAB_6x_AGM154A_R}",					arg_value = 0.1,	DrawArgs = {{18, 0.3}} },
		-- WCMD
		{ CLSID = "{HSAB_8x_CBU103_R}",						arg_value = 0.1,	DrawArgs = {{18, 0.1}} },
		{ CLSID = "{HSAB_8x_CBU105_R}",						arg_value = 0.1,	DrawArgs = {{18, 0.1}} },
		-- AGM-84
		{ CLSID = "{HSAB_4x_AGM84D_R}",						arg_value = 0.1,	DrawArgs = {{18, 0.1}} },
		-- LGB
		{ CLSID = "{HSAB_5x_GBU10}",						arg_value = 0.1,	DrawArgs = {{18, 0.2}} },
		{ CLSID = "{HSAB_5x_GBU12}",						arg_value = 0.1,	DrawArgs = {{18, 0.1}} },
		{ CLSID = "{HSAB_2x_GBU28}",						arg_value = 0.1,	DrawArgs = {{18, 0.1}} },
	}
	local arg3 = 0

	if left then
		arg3 = 0.5
	end

	for i, val in ipairs(result) do
		if left and val.CLSID:find("_R}") then
			val.CLSID = val.CLSID:gsub("_R}", "_L}")
		end

		val.DrawArgs[#val.DrawArgs + 1] = { 3, arg3 }
	end

	result[#result + 1] = { CLSID = "{45447F82-01B5-4029-A572-9AAD28AF0275}",	arg_value = 0.2 }

	return result
end

local function BAY_ROTARY_ASSIGN(clsid)
	return { CLSID = clsid, Type = 8, connector = "Pylon20_R", arg_value = 0.1 }
end

local BAY = {
	BAY_ROTARY_ASSIGN("{8DCAF3A3-7FCF-41B8-BB88-58DEDA878EDE}"), -- AGM-86D*8
	BAY_ROTARY_ASSIGN("{8_x_AGM_86C}"),-- AGM-86C*8
	BAY_ROTARY_ASSIGN("{CSRL_GBU12}"),
	BAY_ROTARY_ASSIGN("{CSRL_GBU31V1}"),
	BAY_ROTARY_ASSIGN("{CSRL_GBU31V3}"),
	BAY_ROTARY_ASSIGN("{CSRL_GBU38V1}"),
	BAY_ROTARY_ASSIGN("{CSRL_GBU54V1}"),
	{ CLSID = "{6C47D097-83FF-4FB2-9496-EAB36DDF0B05}" }, -- 27 Mk-82
	{ CLSID = "{B52H_BAY_3x_GBU12}" },
	{ CLSID = "{B52H_BAY_6x_CBU87}" },
	{ CLSID = "{B52H_BAY_M117}" },
	{ CLSID = "{B52H_BAY_Mk82AIR}" },
	{ CLSID = "{46ACDCF8-5451-4E26-BDDB-E78D5830E93C}" , obsolete = true}, -- AGM-84A*8  , this is obsolete  harppon cannot be launched from bay 
}

add_aircraft({
	Name				=	  'B-52H',
	DisplayName			=	_('B-52H'),
	WorldID				=	23,
	mapclasskey 		= "P0091000027",

	Picture 			= "B-52H.png",
	Rate 				=  100,
	Shape 				= "b-52",
	country_of_origin 	= "USA",
	Countries  = {	},
	singleInFlight 		= false,	

	attribute = {wsType_Air, wsType_Airplane, wsType_Intruder, B_52,
					"Strategic bombers", "Refuelable", "Datalink", "Link16"	},
	Categories = {	},
	
	CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_AVERAGE, LOOK_AVERAGE, LOOK_BAD),
	
	Sensors = {
		OPTIC = {"ASQ-151"},
		RADAR = "B-52H SS radar",
		RWR = "Abstract RWR"
	},	-- end of Sensors
		
	InheriteCommonCallnames = true,
	SpecificCallnames = {
		["USA"] = {
					{_('Buff'),			'Buff'},
					{_('Dump'),			'Dump'},
					{_('Kenworth'),		'Kenworth'}
		}, -- end of USA
	},	-- end of SpecificCallnames

	-- Countermeasures, 
	passivCounterm = {
		CMDS_Edit = false,
		SingleChargeTotal = 1317,
		chaff = {default = 1125, increment = 1, chargeSz = 1},
		flare = {default = 192, increment = 1, chargeSz = 1}
	},
	
	chaff_flare_dispenser = 
	{
		[1] = 
		{
			dir =	{0,	-1,	0},
			pos =	{-2.007, -0.175, 12.194},
		}, -- end of [1]
		[2] = 
		{
			dir =	{0,	-1,	0},
			pos =	{-2.007, -0.175, -12.194},
		}, -- end of [2]
		[3] = 
		{
			dir =	{0,	-1,	0},
			pos =	{-18.574, 0.113, 1.573},
		}, -- end of [3]
		[4] = 
		{
			dir =	{0,	-1,	0},
			pos =	{-18.574, 0.113, -1.573},
		}, -- end of [4]
	}, -- end of chaff_flare_dispenser
	
	Countermeasures = 
	{
		ECM	=	"AN/ALQ-172",
	}, -- end of Countermeasures
	EPLRS	=	true,
	
	Pylons = 
	{
		pylon(1, 1, 6.012, -1.136, -5.514, {connector = "Pylon1" ,use_full_connector_position = true, arg = 308 ,arg_value = 0}, WING_LOADOUT(true)),
		pylon(2, 2, 0.576, -2.000,  0.000, {connector = "disable",use_full_connector_position = true, arg = 309 ,arg_value = 0}, BAY),
		pylon(3, 1, 6.012, -1.136,  5.514, {connector = "Pylon2" ,use_full_connector_position = true, arg = 310 ,arg_value = 0}, WING_LOADOUT(false)),
		pylon(4, 1, 0, 0,  0, {
				connector = "Pylon19_S" ,use_full_connector_position = true, DisplayName = _("TGP")
			}, {
				{ CLSID = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}" }, -- AN/AAQ-28 Litening
				-- { CLSID = "{AN_AAQ_33}" }, -- AN/AAQ-33 Sniper --! no worky rn
			}
		)
	}, -- end of Pylons

	Tasks = {
        aircraft_task(GroundAttack),
        aircraft_task(RunwayAttack),
        aircraft_task(PinpointStrike),
        aircraft_task(AntishipStrike),
		aircraft_task(CAS),
    },
	DefaultTask	= aircraft_task(GroundAttack),
	
	EmptyWeight		 = 83460,
	MaxFuelWeight 	 = 141135,
	MaxHeight	 	 = 17000,
	MaxSpeed 		 = 1000,
	MaxTakeOffWeight = 256735,
	
	M_empty			=	83460,
	M_nominal		=	200000,
	M_max			=	256735,
	M_fuel_max		=	141135,
	H_max			=	16764,	
	CAS_min			=	62,
	V_opt			=	227,
	V_take_off		=	65,
	V_land			=	65,		
	AOA_take_off	=	0,
	stores_number	=	3,
	bank_angle_max	=	45,
	Ny_min			=	0,
	Ny_max			=	2.5,
	tand_gear_max	=	0.577,
	V_max_sea_level	=	178,
	V_max_h			=	266,
	tanker_type		=	1,
	wing_area		=	371,
	wing_span		=	56.4,
	WingSpan		=	56.4,
	thrust_sum_max	=	61680,
	thrust_sum_ab	=	61680,
	Vy_max			=	10.2,
	length			=	49.05,
	height			=	12.4,
	flaps_maneuver	=	1,
	Mach_max		=	0.95,
	range			=	16700,
	RCS				=	100,
	Ny_max_e		=	2,
	brakeshute_name	=	1,
	detection_range_max		=	0,
	IR_emission_coeff		=	4,
	IR_emission_coeff_ab	=	0,	
	wing_tip_pos 			= {-11.0, -2.0, 28.6},
	has_speedbrake				=	true,
	has_afteburner				=	false,	
	has_differential_stabilizer = 	false,
	radar_can_see_ground		=	false,
	bomb_bay_movement 			= 2,
	
	nose_gear_pos 	= 	{ 9.051,	-3.8,	1.24},
	main_gear_pos 	= 	{-6.296,	-3.8,	1.24},
	nose_gear_wheel_diameter	=	1.39,
	main_gear_wheel_diameter	=	1.39,	
	nose_gear_amortizer_direct_stroke        =  0,
	main_gear_amortizer_direct_stroke	     =  0,
	nose_gear_amortizer_reversal_stroke      = -0.477, -- up 	
	main_gear_amortizer_reversal_stroke      = -0.477, --  up 
	nose_gear_amortizer_normal_weight_stroke = -0.3577,
	main_gear_amortizer_normal_weight_stroke = -0.3577,
	wheel_steering_angle_max				 = math.rad(55.0),
	
	average_fuel_consumption	=	0.193,
	air_refuel_receptacle_pos 	= 	{16.7,	1.85,	0},
	
	DamageParts = 	{"b-52_oblomok_wing_R",	"b-52_oblomok_wing_L"},
		
	HumanCockpit	=	false,
	AmmoWeight		=	0,
	bigParkingRamp	=	true,
	Waypoint_Custom_Panel	=	true,
	
	encyclopediaAnimation = {
	args = 	{
			[0] = 1.000000,
			[3] = 1.000000,
			[26] = 1.000000,
			[126] = 0.101000,
			[127] = 0.101000,
			[128] = 0.101000,
			[129] = 0.101000,
		},
	},
	
	engines_count	=	8,	
	engines_nozzles = 
	{
		{
			engine_number = 1,
			pos = 	{-1.82,	-1.02,	-19.0},
			elevation	=	0,
			diameter	=	1.523,
			exhaust_length_ab	=	11.794,
			exhaust_length_ab_K	=	0.76,
			smokiness_level     = 	0.4, 
		},
		{
			engine_number = 2,
			pos = 	{-1.82,	-1.05,	-17.66},
			elevation	=	0,
			diameter	=	1.523,
			exhaust_length_ab	=	11.794,
			exhaust_length_ab_K	=	0.76,
			smokiness_level     = 	0.4, 
		},
		{
			engine_number = 3,
			pos = 	{4.05,	-0.76,	-11.12},
			elevation	=	0,
			diameter	=	1.523,
			exhaust_length_ab	=	11.794,
			exhaust_length_ab_K	=	0.76,
			smokiness_level     = 	0.4, 
		},
		{
			engine_number = 4,
			pos = 	{4.05,	-0.78,	-9.73},
			elevation	=	0,
			diameter	=	1.523,
			exhaust_length_ab	=	11.794,
			exhaust_length_ab_K	=	0.76,
			smokiness_level     = 	0.4, 
		},
		{
			engine_number = 5,
			pos = 	{4.05,	-0.78,	9.73},
			elevation	=	0,
			diameter	=	1.523,
			exhaust_length_ab	=	11.794,
			exhaust_length_ab_K	=	0.76,
			smokiness_level     = 	0.4, 
		},
		{
			engine_number = 6,
			pos = 	{4.05,	-0.76,	11.12},
			elevation	=	0,
			diameter	=	1.523,
			exhaust_length_ab	=	11.794,
			exhaust_length_ab_K	=	0.76,
			smokiness_level     = 	0.4, 
		},
		{
			engine_number = 7,
			pos = 	{-1.82,	-1.05,	17.66},
			elevation	=	0,
			diameter	=	1.523,
			exhaust_length_ab	=	11.794,
			exhaust_length_ab_K	=	0.76,
			smokiness_level     = 	0.4, 
		},
		{
			engine_number = 8,
			pos = 	{-1.82,	-1.02,	19.00},
			elevation	=	0,
			diameter	=	1.523,
			exhaust_length_ab	=	11.794,
			exhaust_length_ab_K	=	0.76,
			smokiness_level     = 	0.4, 
		},
	}, -- end of engines_nozzles
			
	lights_data = 
	{
		typename = "collection",
		lights = {
			[WOLALIGHT_NAVLIGHTS] = {
				typename = "collection",
				lights = {
					{  typename = "Spot", connector = "BANO_2", dir_correction = {azimuth = math.rad(0.0), elevation = math.rad(45.0)},  argument  = 190,
						proto = lamp_prototypes.BANO_8M_red, angle_max = math.rad(160.0), angle_min = math.rad(90.0), movable = true,},				-- red
					{  typename = "Spot", connector = "BANO_1", dir_correction = {azimuth = math.rad(0.0), elevation = math.rad(45.0)},  argument  = 191,
						proto = lamp_prototypes.BANO_8M_green, angle_max = math.rad(160.0), angle_min = math.rad(90.0), movable = true,},				-- green	
					{  typename = "Spot", connector = "BANO_0_L", dir_correction = {azimuth = math.rad(0.0), elevation = math.rad(0.0)},  argument  = 192,
						proto = lamp_prototypes.ANO_3_Bl, range = 75.0, angle_max = math.rad(160.0), angle_min = math.rad(90.0),  movable = true,},				-- white
					{  typename = "Spot", connector = "BANO_0_R", dir_correction = {azimuth = math.rad(0.0), elevation = math.rad(0.0)},  argument  = 192,
						proto = lamp_prototypes.ANO_3_Bl, range = 75.0, angle_max = math.rad(160.0), angle_min = math.rad(90.0),  movable = true,},				-- white				
				},
			},
			[WOLALIGHT_CABIN_NIGHT] = {
				typename = "collection",
				lights = {
					{
						typename = "argumentlight", argument = 69,
					},
				},
			},
			[WOLALIGHT_REFUEL_LIGHTS] = {
						typename = "collection",
						lights = {
							{ typename = "argumentlight", argument = 212, },
						},
			},
			[WOLALIGHT_BEACONS] = {
					typename = "collection",
					lights = {
						{
							typename = "Collection",
							lights = {
								{
									typename = "RotatingBeacon", connector = "RED_BEACON", argument = -1,
									rotary_assembly_argument = 199,
									flood_light_argument = 200,
									proto = lamp_prototypes.MSL_3_2, angular_velocity = math.rad(360.0/1.5),
									range = 0,
								},
							},
						},
					},
				},
			[WOLALIGHT_FORMATION_LIGHTS] = {
				typename = "collection",
				lights = {
					-- 0 -- fuselage bottom formation
					{ typename = "argumentlight", argument = 210, },
				},
			},
			[WOLALIGHT_SPOTS] = {
				typename = "collection",
				lights = {
					[1] = {
						typename = "Collection",
						lights = {
							{
								typename = "Spot", connector = "MAIN_SPOT_PTR_1", dir_correction = {azimuth = math.rad(0.0), elevation = math.rad(3.0)}, argument = 211,
								proto = lamp_prototypes.LFS_P_27_200,range = 5000.0,  angle_max = math.rad(36.0), angle_min = math.rad(21.0),
								exposure = {{0, 0.9, 1.0}}, movable = true,
							},							
							{
								typename = "Spot", connector = "MAIN_SPOT_PTR_4", dir_correction = {azimuth = math.rad(0.0), elevation = math.rad(2.0)}, argument = 211,
								proto = lamp_prototypes.LFS_P_27_200,range = 5000.0,  angle_max = math.rad(36.0), angle_min = math.rad(21.0),
								exposure = {{0, 0.9, 1.0}}, movable = true,
							},
						},
					},
				},
			},
			[WOLALIGHT_TAXI_LIGHTS] = {
				typename = "collection",
				lights = {
					[1] = {
						typename = "Collection",
						lights = {
							{
								typename = "Spot", connector = "RESERV_SPOT_PTR_1", dir_correction = {azimuth = math.rad(3.0), elevation = math.rad(-6.0)}, argument = 208,
								proto = lamp_prototypes.LFS_P_27_1000,range = 900.0,  angle_max = math.rad(40.0), angle_min = math.rad(18.0), 
								exposure = {{0, 0.9, 1.0}}, movable = true,
							},
							{
								typename = "Spot", connector = "RESERV_SPOT_PTR_2", dir_correction = {azimuth = math.rad(-3.0), elevation = math.rad(-7.0)}, argument = 209,
								proto = lamp_prototypes.LFS_P_27_1000,range = 900.0, angle_max = math.rad(45.0), angle_min = math.rad(12.0),
								exposure = {{0, 0.9, 1.0}}, movable = true,
							},
							{
								typename = "Spot", connector = "MAIN_SPOT_PTR_2", dir_correction = {azimuth = math.rad(0.0), elevation = math.rad(-25.0)}, argument = 208,
								proto = lamp_prototypes.LFS_P_27_200, range = 1200.0,
								angle_max = math.rad(82.0), angle_min = math.rad(43.0),
								exposure = {{0, 0.9, 1.0}}, movable = true,
							},
							{
								typename = "Spot", connector = "MAIN_SPOT_PTR_3", dir_correction = {azimuth = math.rad(0.0), elevation = math.rad(-28.0)}, argument = 208,
								proto = lamp_prototypes.LFS_P_27_200, range = 1500.0, 
								angle_max = math.rad(120.0), angle_min = math.rad(80.0),
								exposure = {{0, 0.9, 1.0}}, movable = true,
							},
						},
					},
				},
			},
		},
	}, -- end of lights_data
	
	Damage = verbose_to_dmg_properties({
		["NOSE_CENTER"]				= {args = {146},	critical_damage = 3},
		["NOSE_BOTTOM"]				= {args = {148},	critical_damage = 3},
		["NOSE_TOP"]				= {args = {147},	critical_damage = 3},
		["NOSE_LEFT_SIDE"]			= {args = {150},	critical_damage = 3},
		["NOSE_RIGHT_SIDE"]			= {args = {149},	critical_damage = 3},

		["COCKPIT"]					= {args = {-1},		critical_damage = 10},
	
		["FUSELAGE_LEFT_SIDE"]		= {args = {154},	critical_damage = 5},
		["FUSELAGE_RIGHT_SIDE"]		= {args = {153},	critical_damage = 5},
		["FUSELAGE_BOTTOM"]			= {args = {152},	critical_damage = 4},
		["FUSELAGE_TOP"]			= {args = {151},	critical_damage = 4},

		["TAIL_LEFT_SIDE"]			= {args = {158},	critical_damage = 5},
		["TAIL_RIGHT_SIDE"]			= {args = {157},	critical_damage = 5},
		["TAIL_BOTTOM"]				= {args = {156},	critical_damage = 5},
		["TAIL_TOP"]				= {args = {155},	critical_damage = 5},
		["TAIL"]					= {args = {159},	critical_damage = 4},

		["MTG_1"]					= {args = {168},	critical_damage = 3, deps_cells = {"ENGINE_L_OUT"}}, 
		["MTG_2"]					= {args = {162},	critical_damage = 3, deps_cells = {"ENGINE_L_IN"}}, 
		["MTG_3"]					= {args = {179},	critical_damage = 3, deps_cells = {"ENGINE_R_IN"}}, 
		["MTG_4"]					= {args = {173},	critical_damage = 3, deps_cells = {"ENGINE_R_OUT"}},
		
		["ENGINE_L_OUT"]			= {args = {-1},		critical_damage = 2}, -- fake cells for smoke and fire
		["ENGINE_L_IN"]				= {args = {-1},		critical_damage = 2}, -- fake cells for smoke and fire
		["ENGINE_R_IN"]				= {args = {-1},		critical_damage = 2}, -- fake cells for smoke and fire
		["ENGINE_R_OUT"]			= {args = {-1},		critical_damage = 2}, -- fake cells for smoke and fire
		
		["WING_L_IN"]				= {args = {225}, 	critical_damage = 5, deps_cells = {"WING_L_CENTER", "MTG_2", "FLAP_L_IN"}},
		["WING_L_CENTER"]			= {args = {224}, 	critical_damage = 4, deps_cells = {"WING_L_OUT", "WING_L_PART_OUT", "MTG_1", "FLAP_L_OUT"}},
		["WING_L_OUT"]				= {args = {223},	critical_damage = 4, deps_cells = {"WING_L_PART_OUT"}},
		["WING_L_PART_OUT"]			= {args = {-1},		critical_damage = 2},
		["FLAP_L_IN"]				= {args = {228},	critical_damage = 2},
		["FLAP_L_OUT"]				= {args = {229},	critical_damage = 2},
		
		["WING_R_IN"]				= {args = {215}, 	critical_damage = 5, deps_cells = {"WING_R_CENTER", "MTG_3", "FLAP_R_IN"}},
		["WING_R_CENTER"]			= {args = {214}, 	critical_damage = 4, deps_cells = {"WING_R_OUT", "WING_R_PART_OUT", "MTG_4", "FLAP_R_OUT"}},
		["WING_R_OUT"]				= {args = {213},	critical_damage = 4, deps_cells = {"WING_R_PART_OUT"}},
		["WING_R_PART_OUT"]			= {args = {-1},		critical_damage = 2},
		["FLAP_R_IN"]				= {args = {218},	critical_damage = 2},
		["FLAP_R_OUT"]				= {args = {219},	critical_damage = 2},
	
		["STABILIZER_L_IN"]			= {args = {236},	critical_damage = 2, deps_cells = {"STABILIZER_L_OUT", "ELEVATOR_L_IN"},detachable = { shape =  "b-52_oblomok_stab_L"} },
		["STABILIZER_L_OUT"]		= {args = {235},	critical_damage = 2, deps_cells = {"ELEVATOR_L_OUT"}},
		["ELEVATOR_L_IN"]			= {args = {-1},		critical_damage = 2, deps_cells = {"ELEVATOR_L_OUT"}},
		["ELEVATOR_L_OUT"]			= {args = {-1},		critical_damage = 1},
		
		["STABILIZER_R_IN"]			= {args = {234},	critical_damage = 2, deps_cells = {"STABILIZER_R_OUT", "ELEVATOR_R_IN"},detachable = { shape =  "b-52_oblomok_stab_R"}},
		["STABILIZER_R_OUT"]		= {args = {233},	critical_damage = 2, deps_cells = {"ELEVATOR_R_OUT"}},
		["ELEVATOR_R_IN"]			= {args = {-1},		critical_damage = 2, deps_cells = {"ELEVATOR_R_OUT"}},
		["ELEVATOR_R_OUT"]			= {args = {-1},		critical_damage = 1},
		
		["KEEL_R_OUT"]				= {args = {241},	critical_damage = 4, deps_cells = {"RUDDER_R"}},
		["KEEL_R_CENTER"]			= {args = {242},	critical_damage = 3, deps_cells = {"RUDDER_L", "KEEL_R_OUT"},detachable = { shape =  "b-52_oblomok_keel"}},
		["RUDDER_R"]				= {args = {-1},		critical_damage = 1},
		["RUDDER_L"]				= {args = {-1},		critical_damage = 1, deps_cells = {"RUDDER_R"}},
		
		["GEAR_1"] 					= {args = {-1},		critical_damage = 3, deps_cells = {"WHEEL_1"}},
		["WHEEL_1"]					= {args = {-1},		critical_damage = 3},
		["GEAR_2"] 					= {args = {-1},		critical_damage = 3, deps_cells = {"WHEEL_2"}},
		["WHEEL_2"]					= {args = {-1},		critical_damage = 3},
		["GEAR_3"] 					= {args = {-1},		critical_damage = 3, deps_cells = {"WHEEL_3"}},
		["WHEEL_3"]					= {args = {-1},		critical_damage = 3},
		["GEAR_4"] 					= {args = {-1},		critical_damage = 3, deps_cells = {"WHEEL_4"}},
		["WHEEL_4"]					= {args = {-1},		critical_damage = 3},
		["GEAR_5"] 					= {args = {-1},		critical_damage = 3, deps_cells = {"WHEEL_5"}},
		["WHEEL_5"]					= {args = {-1},		critical_damage = 3},
		["GEAR_6"] 					= {args = {-1},		critical_damage = 3, deps_cells = {"WHEEL_6"}},
		["WHEEL_6"]					= {args = {-1},		critical_damage = 3},
	}),-- end of Damage

	
	SFM_Data = 
	{
		aerodynamics = 
		{
			Cy0	=	0.55,
			Mzalfa	=	6.6,
			Mzalfadt	=	1,
			kjx	=	1.4,
			kjz	=	0.00125,
			Czbe	=	-0.012,
			cx_gear	=	0.015,
			cx_flap	=	0.05,
			cy_flap	=	0.9,
			cx_brk	=	0.06,
			table_data = 
			{
				[1] = 	{0,		0.024,	0.1,	0.0426,	1e-006,	0.5,	20,	1.2},
				[2] = 	{0.1,	0.024,	0.1,	0.0426,	1e-006,	1,		20,	1.2},
				[3] = 	{0.2,	0.024,	0.1,	0.0426,	1e-006,	1.5,	20,	1.2},
				[4] = 	{0.3,	0.024,	0.1,	0.0426,	1e-006,	2,		20,	1.2},
				[5] = 	{0.4,	0.024,	0.1,	0.0426,	1e-006,	2.5,	20,	1.2},
				[6] = 	{0.5,	0.024,	0.1,	0.0426,	1e-006,	3,		20,	1.2},
				[7] = 	{0.6,	0.024,	0.1,	0.044,	1e-006,	3.5,	20,	1.2},
				[8] = 	{0.7,	0.025,	0.1,	0.045,	0.02,	3.5,	20,	1},
				[9] = 	{0.8,	0.029,	0.1,	0.049,	0.05,	3.5,	20,	0.9},
				[10] = 	{0.9,	0.04,	0.1,	0.071,	0.07,	3.5,	20,	0.8},
				[11] = 	{1,		0.06,	0.1,	0.138,	0.2,	3.5,	20,	0.76666666666667},
				[12] = 	{1.5,	0.06,	0.1,	0.138,	0.2,	3.5,	20,	0.6},
				[13] = 	{2,		0.06,	0.1,	0.138,	0.2,	3.5,	20,	0.6},
			}, -- end of table_data
		}, -- end of aerodynamics
		engine = 
		{
			type	=	"TurboJet",
            Nominal_RPM = 14460.0,
			Nmg	= 7690.0 / 14460.0 * 100,
            Nominal_Fan_RPM = 5175.0,
            Startup_Prework = 80.0,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	1,
			ForsRUD	=	1,
			hMaxEng	=	19.5,
			dcx_eng	=	0.0085,
			cemax	=	0.37,
			cefor	=	0.37,
			dpdh_m	=	19000,
			dpdh_f	=	19000,
			table_data = 
			{
				[1] = 	{0,		608000,	608000},
				[2] = 	{0.1,	568000,	568000},
				[3] = 	{0.2,	520000,	520000},
				[4] = 	{0.3,	484000,	484000},
				[5] = 	{0.4,	440000,	440000},
				[6] = 	{0.5,	418000,	418000},
				[7] = 	{0.6,	410000,	410000},
				[8] = 	{0.7,	436000,	436000},
				[9] = 	{0.798,	470000,	470000},
				[10] = 	{0.9,	524000,	524000},
				[11] = 	{1,		560000,	560000},
			}, -- end of table_data
		}, -- end of engine
	}, -- end of SFM_Data
		
	HumanRadio = 
	{
		maxFrequency	=	399.975,
		minFrequency	=	100,
		modulation	=	0,
		editable	=	true,
		frequency	=	251,
	}, -- end of HumanRadio
	
	crew_members = 
	{
		[1] = 
		{
			ejection_seat_name	=	18,
			role_display_name 	 = _("Pilot in command"),
			role	=	"pilot",
			bailout_arg	=	118,
			ejection_added_speed = 	{0,	30,	-0.3},
			drop_canopy_name	=	12,
			pos = 	{18.4,	1.2,	-0.5},
		}, -- end of [1]
		[2] = 
		{
			ejection_seat_name	=	18,
			role_display_name 	 = _("Copilot"),
			role	=	"copilot",
			bailout_arg	=	118,
			pilot_body_arg		= 472,
			ejection_added_speed = 	{0,	30,	0.3},
			drop_canopy_name	=	0,
			pos = 	{18.4,	1.2,	0.5},
		}, -- end of [2]
		[3] = 
		{
			ejection_seat_name	=	18,
			role_display_name 	 = _("EW officer"),
			role	=	"flight_officer",
			bailout_arg	=	118,
			pilot_body_arg		= 487,
			ejection_added_speed = 	{0,	30,	-0.3},
			drop_canopy_name	=	0,
			pos = 	{15,	1.2,	-0.5},
			ejection_rotation = {0.0,	180.0,	0.0},
		}, -- end of [3]
		[4] = 
		{
			ejection_seat_name	=	18,
			role_display_name 	 = _("Radar Navigator"),
			role	=	"flight_officer",
			bailout_arg	=	118,
			pilot_body_arg		= 488,
			ejection_added_speed = 	{0,	-30,	-0.3},
			drop_canopy_name	=	0,
			pos = 	{16.48,	-0.879,	-0.5},
		}, -- end of [4]
		[5] = 
		{
			ejection_seat_name	=	18,
			role 				 = "flight_officer",
			role_display_name 	 = _("Navigator"),
			bailout_arg	=	118,
			pilot_body_arg		= 489,
			ejection_added_speed = 	{0,	-30,	0.3},
			drop_canopy_name	=	0,
			pos = 	{16.48,	-0.879,	0.5},
		}, -- end of [5]
	}, -- end of crew_members
	
	mechanimations = {
            Door0 = {
                {Transition = {"Close", "Open"}, Sequence = {{C = {{"Sleep", "for", 0.0}}}}},
                {Transition = {"Open", "Close"}, Sequence = {{C = {{"Sleep", "for", 0.0}}}}},
                {Transition = {"Open", "Board"}, Sequence = {{C = {{"Sleep", "for", 50.0}}}, {C = {{"Arg", 38, "to", 1.0, "in", 3.0}}}}},
                {Transition = {"Board", "Open"}, Sequence = {{C = {{"Arg", 38, "to", 0.0, "in", 6.0}}}}},
				{Transition = {"Any", "Bailout"}, Sequence = {{C = {{"PosType", 9}, {"Sleep", "for", 0.5}}}, {C = {{"Arg", 118, "set", 1.0}}}}},
            },
			Door1 = {DuplicateOf = "Door0"},
            Door2 = {DuplicateOf = "Door0"},
            Door3 = {DuplicateOf = "Door0"},
            Door4 = {DuplicateOf = "Door0"},
			Door5 = {DuplicateOf = "Door0"},
			ServiceHatches = {
					{Transition = {"Close", "Open"}, Sequence = {{C = {{"PosType", 3}, {"Sleep", "for", 30.0}}}, {C = {{"Arg", 24, "set", 1.0}}}}},
					{Transition = {"Open", "Close"}, Sequence = {{C = {{"PosType", 6}, {"Sleep", "for", 5.0}}}, {C = {{"Arg", 24, "set", 0.0}}}}},
				},
				
			BombBay = {
				{Transition = {"Close", "Open"}, Sequence = {
					{C = {{"Arg", 26, "to", 1.0, "in", 2.0, "sign", 1}}},
				}},
				{Transition = {"Open", "Close"}, Sequence = {
					{C = {{"Arg", 26, "to", 0.0, "in", 4.5, "sign", -1}}},
				}},
			},
        }, -- end of mechanimations
		
	fires_pos = 
		{
			[1] = 	{-10.305,	-2.064,	0},
			[2] = 	{5.345,	1.384,	3.288},
			[3] = 	{5.345,	1.384,	-3.288},
			[4] = 	{-0.82,	0.665,	12.1},
			[5] = 	{-0.82,	0.665,	-12.1},
			[6] = 	{-5.2,	-0.15,	19.16},
			[7] = 	{-5.2,	-0.15,	-19.16},
			[8] = 	{4.08,	-0.88,	10.4},
			[9] = 	{4.08,	-0.88,	-10.4},
			[10] = 	{-1.8,	-1.067,	18.31},
			[11] = 	{-1.8,	-1.067,	-18.31},
		}, -- end of fires_pos
		
	effects_presets = {
		--{effect = "APU_STARTUP_BLAST", preset = "F18", ttl = 3.0},
		{effect = "OVERWING_VAPOR", file = current_mod_path.."/Effects/B_52H_overwingVapor.lua"},
	},
	
	AddPropAircraft = {
		{ id = "datalink_Label", control = 'label', label = _('DATALINK'), xLbl = 150, playerOnly = false},
		{ id = "VoiceCallsignLabel" , control = 'editbox', label = _('Voice Callsign Label'), getDefault = getCallsignLabel, onChange = onChange_VoiceCallsignLabel, playerOnly = false},
		{ id = "VoiceCallsignNumber" , control = 'editbox', label = _('Voice Callsign Number'), getDefault = getCallsignNumber, onChange = onChange_VoiceCallsignNumber, playerOnly = false},		
		{ id = "STN_L16" , control = 'editbox', label = _('STN'), getDefault = getSTN, onChange = onChange_STN, onFocus = onFocus_STN, playerOnly = false},
	}
}) -- end of B_52H

